import keyBy from 'lodash/keyBy';
import camelCaseKeys from 'camelcase-keys';

import {IFlightDTO} from 'server/api/AviaBookingApi/types/IBookingVariantsResponse';
import {IBookingFlightModel} from 'server/services/AviaBookingService/variants/types';
import {IReferenceDTO} from 'server/api/AviaBookingApi/types/IReferenceDTO';
import {ISegmentFare} from 'server/api/AviaBookingApi/types/ISegmentFare';

export function flightDTOtoFlightModel(
    rawFlight: IFlightDTO,
    reference: IReferenceDTO,
): IBookingFlightModel {
    const airports = keyBy(reference.airports, 'id');
    const settlements = keyBy(reference.settlements, 'id');
    const airlines = keyBy(reference.airlines, 'id');

    const departureAirport = airports[rawFlight.from];
    const arrivalAirport = airports[rawFlight.to];
    const departureSettlement = settlements[departureAirport.settlement];
    const arrivalSettlement = settlements[arrivalAirport.settlement];
    const departureDate = rawFlight.departure;
    const arrivalDate = rawFlight.arrival;
    const company = airlines[rawFlight.marketingAviaCompany];
    const operatingCompany = airlines[rawFlight.operatingAviaCompany];
    const flightNumber = rawFlight.number || '';

    // Hotels API and Booking API returns same model with different case
    const fareTerms = camelCaseKeys(rawFlight.fareTerms, {
        deep: true,
    }) as unknown as ISegmentFare;

    return {
        id: rawFlight.id,
        flightNumber,
        departureAirport,
        arrivalAirport,
        departureSettlement,
        arrivalSettlement,
        departureDate,
        arrivalDate,
        airline: company,
        company,
        operatingCompany,
        fareTerms,
    };
}
