import {ClassOrFunctionReturning} from 'awilix';
import {makeInvoker} from 'awilix-express';

import {Request, Response} from '@yandex-data-ui/core/lib/types';

export default function makeProxyInvoker<T>(
    functionOrClass: ClassOrFunctionReturning<T>,
): T {
    const invoker = makeInvoker(functionOrClass);
    return new Proxy(
        {},
        {
            get(target: any, p: string) {
                const handler = invoker(p);
                return (req: Request, res: Response) => {
                    handler(req, res, console.error);
                };
            },
        },
    ) as T;
}
