import getProjectName from '../getProjectName';

interface IMetrikaWebvisorConfig {
    inclusionPercent: {
        projects: {
            [projectName: string]: number;
        };
        defaultPercent: number;
    };
}

export default function webvisorIsEnabled(
    url: string,
    config: Nullable<IMetrikaWebvisorConfig>,
) {
    if (!config) {
        return true;
    }

    const {
        inclusionPercent: {projects, defaultPercent},
    } = config;

    const projectName = getProjectName(url);
    const percent = projects[projectName] ?? defaultPercent;

    return Math.random() <= percent;
}
