const decodingMap = require('./win1251DecodingMap');

/**
 * Декодирует строку в кодировке percent win1251 endcoded
 *
 * @param {string} path
 * @return {string}
 */
function decodeWin1251URI(path) {
    return path.replace(
        /%([0-9A-F]{2})/g,
        (match, hex) => decodingMap.get(hex) || match,
    );
}

module.exports = decodeWin1251URI;
