const iconv = require('iconv-lite');

/**
 * Строит словарь HEX Win1251 -> Str UTF-8
 *
 * @returns {Map<string, string>}
 */
function buildWin1251DecodingMap() {
    const decodingMap = new Map();

    // Начиная с кода C0 в кодировке идут русские буквы
    for (let char = 0xc0; char <= 0xff; char++) {
        const key = char.toString(16).toUpperCase().padStart(2, '0');
        const value = iconv.decode(Buffer.from([char]), 'win1251');

        decodingMap.set(key, value);
    }

    return decodingMap;
}

const win1251DecodingMap = buildWin1251DecodingMap();

module.exports = win1251DecodingMap;
