/**
 * @param {string} ref
 * @return {string}
 */
function tryDecodeRef(ref) {
    try {
        return decodeURIComponent(ref);
    } catch (e) {
        return ref;
    }
}

const ORGANIC = {
    SEARCH: 'search_suggest',
    YANDEX: 'yandex_organic',
    GOOGLE: 'google_organic',
};

/**
 * @param {string|undefined} ref
 * @return {string|undefined}
 */
module.exports = function (ref) {
    const yandexSerp = /^https:\/\/(www\.)?yandex\.(com\.tr|[a-z]{2,4})\//;
    const googleSerp = /^https:\/\/(www\.)?google\.(com\.tr|[a-z]{2,4})\//;
    const yandexSuggest = 'from=yandex.ru;suggest';

    if (ref) {
        const decodedRef = tryDecodeRef(ref);

        if (decodedRef.includes(yandexSuggest)) {
            return ORGANIC.SEARCH;
        }

        if (yandexSerp.test(ref)) {
            return ORGANIC.YANDEX;
        }

        if (googleSerp.test(ref)) {
            return ORGANIC.GOOGLE;
        }
    }

    return undefined;
};
