const MARKS = require('../constants/marks');

const {
    WIZARD_FLAGS_QUERY_NAMES,
    WIZARD_REQ_ID_QUERY_NAMES,
} = require('utilities/url/wizard/wizardQueryNames');

const FIELDS_TO_VALIDATE = [
    MARKS.CLID,
    MARKS.STID,
    ...WIZARD_FLAGS_QUERY_NAMES,
    MARKS.SERP_UUID,
    ...WIZARD_REQ_ID_QUERY_NAMES,
];

module.exports = function logInvalidQueryTypes(req) {
    const {query, utils} = req;

    FIELDS_TO_VALIDATE.forEach(field => {
        if (Array.isArray(query[field])) {
            utils.logWarn(`Unexpected array type of utm label "${field}"`);
        }
    });
};
