/**
 * @typedef {import('./types/IUtmMap').IUtmMap} IUtmMap
 */

const utmKeys = [
    'utm_source',
    'utm_medium',
    'utm_campaign',
    'utm_content',
    'utm_term',
];

/**
 * @param {Record<string, string>} query
 * @returns {IUtmMap}
 */
module.exports = function (query) {
    return utmKeys.reduce((utms, k) => {
        const val = query[k];
        if (val) {
            utms[k] = Array.isArray(val) ? val.join(',') : val;
        }
        return utms;
    }, {});
};
