/**
 * @typedef {import('@yandex-data-ui/core/lib/types').Response} Response
 */

const getCookieParams = require('./getCookieParams');

/**
 * @param {Response} res
 * @param {Record<string, string>} query
 * @param {Record<string, string>} cookies
 * @param {string} name
 * @param {string} value
 * @returns {void}
 */
module.exports = function (res, query, cookies, name, value) {
    if (query[name]) {
        res.aviaCookie(name, value, getCookieParams(10));
    } else if (cookies[name]) {
        res.aviaClearCookie(name);
    }
};
