import {FC, memo} from 'react';
import {useSelector} from 'react-redux';

import {ADS_SCRIPT} from 'constants/urls/externals';

import isBotSelector from 'selectors/common/isBot';

import {adBlockManager} from 'utilities/adBlockManager/adBlockManager';

import DynamicScript from 'components/DynamicScript/DynamicScript';

const AdsScript: FC = () => {
    const isBot = useSelector(isBotSelector);

    if (isBot) {
        return null;
    }

    return (
        <DynamicScript
            src={ADS_SCRIPT}
            onLoad={adBlockManager.onSuccessLoadAdScript}
            onError={adBlockManager.onFailedLoadAdScript}
        />
    );
};

export default memo(AdsScript);
