import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';

import cx from './Advantage.scss';

interface IAdvantageProps extends IWithClassName, IWithQaAttributes {
    title: string;
    description: React.ReactNode;
    IconComponent: React.FC<IIconProps>;
    iconWidth: number;
    iconHeight: number;
}

const Advantage: React.FC<IAdvantageProps> = props => {
    const {
        className,
        title,
        description,
        IconComponent,
        iconWidth,
        iconHeight,
    } = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx('root', deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(props)}
        >
            <IconComponent
                className={cx('icon')}
                width={iconWidth}
                height={iconHeight}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'icon',
                })}
            />

            <Heading
                className={cx('title')}
                level="3"
                {...prepareQaAttributes({
                    parent: props,
                    current: 'title',
                })}
            >
                {title}
            </Heading>

            <Box
                above={2}
                textSize="s"
                {...prepareQaAttributes({
                    parent: props,
                    current: 'description',
                })}
            >
                {description}
            </Box>
        </div>
    );
};

export default React.memo(Advantage);
