import React, {FunctionComponent} from 'react';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import cx from './Anchor.scss';

interface IAnchorProps {
    anchorId?: string;
    anchorIds?: string[];
}

/**
 * Компонент добавляет якорь на страницу, уже с поправкой на fixed хедер
 */
export const Anchor: FunctionComponent<IAnchorProps> = ({
    anchorId,
    anchorIds,
}) => {
    const deviceType = useDeviceType();

    return (
        <div className={cx('root')}>
            {anchorId && (
                <div
                    id={anchorId}
                    className={cx(
                        'anchor',
                        deviceModDesktop('anchor', deviceType),
                    )}
                />
            )}
            {anchorIds &&
                anchorIds.map(id => (
                    <div
                        key={id}
                        id={id}
                        className={cx(
                            'anchor',
                            deviceModDesktop('anchor', deviceType),
                        )}
                    />
                ))}
        </div>
    );
};

export default React.memo(Anchor);
