import React, {FC, ReactNode} from 'react';
import {Route, RouteProps, RouteComponentProps} from 'react-router-dom';

type TProps = RouteProps & {meta: React.ComponentType};

const AppRoute: FC<TProps> = ({
    meta: Meta,
    component: Component,
    render,
    ...rest
}) => {
    return (
        <Route
            {...rest}
            render={(props: RouteComponentProps): ReactNode => (
                <>
                    <Meta />
                    {Component && <Component {...props} />}
                    {render && render(props)}
                </>
            )}
        />
    );
};

export default AppRoute;
