import {Meta} from '@storybook/react/types-6-0';

import {useToggle} from 'utilities/hooks/useToggle';

import Text from 'components/Text/Text';
import Button from 'components/Button/Button';

import AutoHeightAnimateControl from './AutoHeightAnimateControl';

export default {
    title: 'Example/AutoHeightAnimateControl',
    component: AutoHeightAnimateControl,
} as Meta;

export const Simple = () => {
    const [isVisible, toggle] = useToggle(false);

    return (
        <>
            <Button theme="secondary" onClick={toggle}>
                {isVisible ? 'Hide' : 'Show'}
            </Button>
            <AutoHeightAnimateControl canShowComponent={isVisible}>
                <Text>
                    Lorem Ipsum is simply dummy text of the printing and
                    typesetting industry. Lorem Ipsum has been the industrys
                    standard dummy text ever since the 1500s, when an unknown
                    printer took a galley of type and scrambled it to make a
                    type specimen book. It has survived not only five centuries,
                    but also the leap into electronic typesetting, remaining
                    essentially unchanged. It was popularised in the 1960s with
                    the release of Letraset sheets containing Lorem Ipsum
                    passages, and more recently with desktop publishing software
                    like Aldus PageMaker including versions of Lorem Ipsum.
                </Text>
            </AutoHeightAnimateControl>
        </>
    );
};
