import React, {FunctionComponent} from 'react';
import {animated, Spring} from 'react-spring';

import {IWithClassName} from 'types/withClassName';

import {useElementSize} from 'utilities/hooks/useElementSize';

import cx from './AutoHeightAnimateControl.scss';

const TRANSITION_CONFIG = {
    tension: 285,
    friction: 30,
    precision: 0.1,
};

interface IAutoHeightAnimateControlProps extends IWithClassName {
    children: React.ReactNode;
    canShowComponent: boolean;
    onAnimationEnd?: () => void;
    contentClassName?: string;
}

const AutoHeightAnimateControl: FunctionComponent<IAutoHeightAnimateControlProps> =
    ({
        children,
        canShowComponent = false,
        className,
        contentClassName,
        onAnimationEnd,
    }) => {
        const {
            ref,
            size: {height: contentHeight},
        } = useElementSize<string, HTMLDivElement>({watchForChanges: true});

        return (
            <div className={cx('root')}>
                <Spring
                    to={{
                        height: canShowComponent ? contentHeight : 0,
                        opacity: canShowComponent ? 1 : 0,
                    }}
                    config={TRANSITION_CONFIG}
                    onRest={onAnimationEnd}
                >
                    {(styles): React.ReactElement => (
                        <animated.div
                            style={{...styles, overflow: 'hidden'}}
                            className={className}
                        >
                            <div ref={ref} className={contentClassName}>
                                {children}
                            </div>
                        </animated.div>
                    )}
                </Spring>
            </div>
        );
    };

export default AutoHeightAnimateControl;
