import {IWithClassName} from 'src/types/withClassName';

/* Components */
import TravelImage from 'components/TravelImage/TravelImage';

/* Init Styles */
import cx from './Avatar.scss';

/* Components Types */
export interface IAvatarProps extends IWithClassName {
    src: string;
    size: 'xs' | 's' | 'm' | 'l' | 'xl';
}

const Avatar = ({src, size}: IAvatarProps) => (
    <TravelImage
        className={cx('avatar', `avatar_size_${size}`)}
        src={src}
        hasFitCover={true}
    />
);

export default Avatar;
