import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';

import BaggageIconWithWeight, {
    EBaggageWithWeightIconSize,
    EBaggageWithWeightIconType,
} from './BaggageIconWithWeight';

export default {
    title: 'Example/BaggageIconWithWeight',
    component: BaggageIconWithWeight,
} as Meta;

export const States: TStorybookFunctionComponent = () => {
    return (
        <Box between={2}>
            <Heading level={3}>
                Багаж не включен в стоимость, нет информации о весе
            </Heading>

            <Flex between={2} inline nowrap>
                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    iconSize={EBaggageWithWeightIconSize.M}
                />
            </Flex>

            <Heading level={3}>
                Багаж не включен в стоимость, есть информации о весе и/или
                количестве
            </Heading>

            <Flex between={2} inline nowrap>
                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                />
            </Flex>

            <Heading level={3}>
                Багаж включен в стоимость, нет информации о весе
            </Heading>

            <Flex between={2} inline nowrap>
                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    iconSize={EBaggageWithWeightIconSize.M}
                />
            </Flex>

            <Heading level={3}>
                Багаж включен в стоимость, есть информации о весе и/или
                количестве
            </Heading>

            <Flex between={2} inline nowrap>
                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={32}
                    iconSize={EBaggageWithWeightIconSize.M}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.S}
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included
                    weight={32}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                />
            </Flex>

            <Heading level={3}>С припиской рубля</Heading>

            <Flex between={2} inline nowrap>
                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                    allowRuble
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                    allowRuble
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.BAGGAGE}
                    included={false}
                    weight={5}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                    allowRuble
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.S}
                    allowRuble
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={5}
                    iconSize={EBaggageWithWeightIconSize.M}
                    allowRuble
                />

                <BaggageIconWithWeight
                    type={EBaggageWithWeightIconType.CARRY_ON}
                    included={false}
                    weight={5}
                    count={2}
                    iconSize={EBaggageWithWeightIconSize.M}
                    allowRuble
                />
            </Flex>
        </Box>
    );
};
