import React, {useMemo} from 'react';

import {EBaggageWithWeightIconSize} from 'components/BaggageIconWithWeight/BaggageIconWithWeight';
import BaggageIcon16 from 'icons/16/Baggage';
import BaggageIcon24 from 'icons/24/Baggage';
import BaggageNoSizeIcon24 from 'icons/24/BaggageNoSize';
import BaggageNoSizeIcon16 from 'icons/16/BaggageNoSize';

interface IBaggageIconProps {
    size: EBaggageWithWeightIconSize;
    empty?: boolean;
}

const BaggageIcon: React.FC<IBaggageIconProps> = props => {
    const {size, empty = false} = props;

    const Icon = useMemo(() => {
        const isSmallSize = size === EBaggageWithWeightIconSize.S;

        if (empty) {
            return isSmallSize ? BaggageNoSizeIcon16 : BaggageNoSizeIcon24;
        }

        return isSmallSize ? BaggageIcon16 : BaggageIcon24;
    }, [size, empty]);

    return <Icon />;
};

export default React.memo(BaggageIcon);
