import React from 'react';
import Helmet from 'react-helmet';

import {PRODUCTION_PROJECT_URL} from 'constants/common';

import * as i18nBlockCommon from 'i18nNew/common';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';
import favicons from 'components/BaseTravelHelmet/images/favicons';
import ogImageDefault from 'components/BaseTravelHelmet/images/ogImageDefault-180x180.png';

const BaseTravelHelmet: React.FC = () => (
    <>
        <Helmet>
            <link
                rel="shortcut icon"
                type="image/x-icon"
                href={favicons.common}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="16x16"
                href={favicons[16]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="32x32"
                href={favicons[32]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="57x57"
                href={favicons[57]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="64x64"
                href={favicons[64]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="76x76"
                href={favicons[76]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="120x120"
                href={favicons[120]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="144x144"
                href={favicons[144]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="152x152"
                href={favicons[152]}
            />
            <link
                rel="icon"
                type="image/png"
                sizes="180x180"
                href={favicons[180]}
            />
            <link rel="apple-touch-icon" sizes="57x57" href={favicons[57]} />
            <link rel="apple-touch-icon" sizes="60x60" href={favicons[60]} />
            <link rel="apple-touch-icon" sizes="76x76" href={favicons[76]} />
            <link rel="apple-touch-icon" sizes="114x114" href={favicons[114]} />
            <link rel="apple-touch-icon" sizes="120x120" href={favicons[120]} />
            <link rel="apple-touch-icon" sizes="144x144" href={favicons[144]} />
            <link rel="apple-touch-icon" sizes="152x152" href={favicons[152]} />
            <link rel="apple-touch-icon" sizes="180x180" href={favicons[180]} />
        </Helmet>

        <DocumentMeta
            title={i18nBlockCommon.metaDotTitle()}
            description={i18nBlockCommon.metaDotDescription()}
            robots="noyaca"
            extra={[
                {name: 'msapplication-TileColor', content: '#DA532C'},
                {name: 'msapplication-TileImage', content: favicons.mstile},
                {name: 'theme-color', content: '#FFFFFF'},
            ]}
        />

        <SocialSharingMeta
            url={PRODUCTION_PROJECT_URL}
            type="website"
            title={i18nBlockCommon.metaDotTitle()}
            description={i18nBlockCommon.metaDotDescription()}
            image={ogImageDefault}
            imageHeight={180}
            imageWidth={180}
            locale="ru_RU"
            extra={[
                {
                    property: 'og:site_name',
                    content: i18nBlockCommon.metaDotSitename(),
                },
            ]}
        />
    </>
);

export default BaseTravelHelmet;
