import React, {PureComponent} from 'react';
import _noop from 'lodash/noop';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18nNew/hotels-BookInvalidInputModal';

import ErrorModal from 'components/ErrorModal/ErrorModal';
import Text from 'components/Text/Text';

import cx from './BookInvalidInputModal.scss';

interface IBookInvalidInputModalProps {
    actionHandler: () => void;
    actionTitle?: string;
    customerEmail?: string;
    fieldType: any;
    isVisible: boolean;
    textContent?: JSX.Element;
    title?: string;
}

class BookInvalidInputModal extends PureComponent<IBookInvalidInputModalProps> {
    static defaultProps = {
        actionHandler: _noop,
        actionTitle: '',
        customerEmail: '',
        fieldType: '',
        isVisible: false,
        textContent: null,
        title: '',
    };

    private renderTextContent = (fieldType: any): React.ReactNode => {
        let textContent = <div />;

        switch (fieldType) {
            case 'OrderCancellationDetailsFieldType.EMAIL': {
                textContent = (
                    <div className={cx('invalidEmailTextContent')}>
                        <div className={cx('problemText')}>
                            <Text>
                                {insertJSXIntoKey(
                                    i18nBlock.invalidEmailDotProblemText,
                                )({
                                    brTag: <br key="problemTextDivider" />,
                                    email: this.props.customerEmail || '',
                                })}
                            </Text>
                        </div>
                        <div>
                            <Text>
                                {i18nBlock.invalidEmailDotSuggestionText()}
                            </Text>
                        </div>
                    </div>
                );

                break;
            }

            default: {
                break;
            }
        }

        return textContent;
    };

    private getActionTitle(fieldType: any): string {
        switch (fieldType) {
            case 'OrderCancellationDetailsFieldType.EMAIL': {
                return i18nBlock.invalidEmailDotReturnToForm();
            }

            default: {
                return '';
            }
        }
    }

    private getTitle(fieldType: any): string {
        switch (fieldType) {
            case 'OrderCancellationDetailsFieldType.EMAIL': {
                return i18nBlock.invalidEmailDotTitle();
            }

            default: {
                return '';
            }
        }
    }

    render(): React.ReactNode {
        const {
            actionHandler,
            actionTitle,
            fieldType,
            isVisible,
            textContent,
            title,
        } = this.props;

        return (
            <ErrorModal
                isVisible={isVisible}
                primaryAction={{
                    type: 'button',
                    title: actionTitle || this.getActionTitle(fieldType),
                    handler: actionHandler,
                }}
                title={title || this.getTitle(fieldType)}
            >
                {textContent || this.renderTextContent(fieldType)}
            </ErrorModal>
        );
    }
}

export default BookInvalidInputModal;
