import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Spinner, {ISpinnerProps} from 'components/Spinner/Spinner';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import cx from './BookLoader.scss';

interface IBookLoaderProps extends IWithClassName, IWithQaAttributes {
    title?: string;
    description?: string;
    isLoading?: boolean;
    isModalView?: boolean;
    spinnerSize?: ISpinnerProps['size'];
}

const BookLoader: React.FC<IBookLoaderProps> = ({
    className,
    title,
    description,
    spinnerSize = 'l',
    isModalView = false,
    isLoading = false,
    ...props
}) => {
    if (!isLoading) {
        return null;
    }

    return (
        <DeviceTypeContext.Consumer>
            {({isMobile}): React.ReactNode => (
                <section
                    className={cx('bookLoader', className, {
                        bookLoader_isModal: isModalView,
                        bookLoader_mobile: isMobile,
                    })}
                    {...prepareQaAttributes(props)}
                >
                    <Spinner size={spinnerSize} />
                    {title && <h3 className={cx('title')}>{title}</h3>}
                    {description && (
                        <h5 className={cx('description')}>{description}</h5>
                    )}
                </section>
            )}
        </DeviceTypeContext.Consumer>
    );
};

BookLoader.defaultProps = {
    ...prepareQaAttributes('loader'),
};

export default BookLoader;
