import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';

import * as i18nBlock from 'i18nNew/hotels-BookPaymentFailed';

export default function getPaymentErrorText(
    errorCode?: EOriginalPaymentErrorCode,
): string {
    switch (errorCode) {
        case EOriginalPaymentErrorCode.AUTHORIZATION_REJECT:
            return i18nBlock.errorDotTypeDotAuthorizationReject();
        case EOriginalPaymentErrorCode.EXPIRED_CARD:
            return i18nBlock.errorDotTypeDotExpiredCard();
        case EOriginalPaymentErrorCode.FAIL_3DS:
            return i18nBlock.errorDotTypeDotFail3Ds();
        case EOriginalPaymentErrorCode.LIMIT_EXCEEDED:
            return i18nBlock.errorDotTypeDotLimitExceeded();
        case EOriginalPaymentErrorCode.NOT_ENOUGH_FUNDS:
            return i18nBlock.errorDotTypeDotNotEnoughFunds();
        case EOriginalPaymentErrorCode.TRANSACTION_NOT_PERMITTED:
            return i18nBlock.errorDotTypeDotTransactionNotPermitted();
        case EOriginalPaymentErrorCode.USER_CANCELLED:
            return i18nBlock.errorDotTypeDotUserCancelled();
        case EOriginalPaymentErrorCode.RESTRICTED_CARD:
            return i18nBlock.errorDotTypeDotRestrictedCard();
        case EOriginalPaymentErrorCode.BLACKLISTED:
            return i18nBlock.errorDotTypeDotBlacklisted();
        case EOriginalPaymentErrorCode.PAYMENT_TIMEOUT:
            return i18nBlock.paymentTimeoutErrorMessage();
        case EOriginalPaymentErrorCode.OTHER:
            return i18nBlock.errorDotTypeDotOther();
        default:
            return i18nBlock.errorDotDefaultDescription();
    }
}
