import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Box from 'components/Box/Box';

import BookPriceInfo from './BookPriceInfo';

export default {
    title: 'Example/BookPriceInfo',
    component: BookPriceInfo,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box between="5">
        <BookPriceInfo
            text="Стоимость без промокода"
            price={{value: 1000, currency: CurrencyType.RUB}}
        />
        <BookPriceInfo
            price={{value: 1000, currency: CurrencyType.RUB}}
            lastPrice={{value: 999, currency: CurrencyType.RUB}}
        />
        <BookPriceInfo
            text="Стоимость изменилась"
            price={{value: 1000, currency: CurrencyType.RUB}}
            lastPrice={{value: 999, currency: CurrencyType.RUB}}
        />
    </Box>
);
