import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import Form from 'components/Form/Form';
import Button from 'components/Button/Button';

import BookingContactsForm from './BookingContactsForm';
import validationInfo from './__mocks__/contactsValidation';

export default {
    title: 'Example/BookingContactsForm',
    component: BookingContactsForm,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Form validationInfo={validationInfo} onSubmit={noop}>
        {({handleSubmit}): ReactNode => (
            <form onSubmit={handleSubmit}>
                <BookingContactsForm />

                <div style={{marginTop: 15}}>
                    <Button type="submit">Submit</Button>
                </div>
            </form>
        )}
    </Form>
);
