import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';
import CheckCircleIcon from 'icons/24/CheckCircle';

import BorderPositioned, {TDirection} from './BorderPositioned';

export default {
    title: 'Example/BorderPositioned',
    component: BorderPositioned,
} as Meta;

const POSITIONS: TDirection[] = [
    'top-left',
    'top-right',
    'top-right-plus',
    'bottom-left',
    'bottom-right',
];

export const Simple: TStorybookFunctionComponent = () => (
    <BorderPositioned badge={<CheckCircleIcon color="#267eff" />}>
        <Button>Кнопуля</Button>
    </BorderPositioned>
);

export const Position: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={POSITIONS.map(position => ({
            name: position,
            props: {posititon: position},
            example: (
                <BorderPositioned
                    badge={<CheckCircleIcon color="#267eff" />}
                    direction={position}
                >
                    <Button>Кнопуля</Button>
                </BorderPositioned>
            ),
        }))}
    />
);
