import {useEffect, useContext} from 'react';

import BottomSheetManagerContext from '../components/BottomSheetManager/BottomSheetManagerContext';

// фикс бага https://st.yandex-team.ru/LEGOSUPPORT-325
/**
 * Фикс проблемы "После закрытия Drawer на мобильном контент страницы некоторое время не скролится"
 * @see {@link https://st.yandex-team.ru/LEGOSUPPORT-325|LEGOSUPPORT-325}
 * @todo выпилить как пофиксят на стороне Лего
 */
const usePreventScrollFix = (): void => {
    const context = useContext(BottomSheetManagerContext);

    useEffect(() => {
        if (context.hasOpenedLayers()) {
            return;
        }

        document.body.style.overflow = '';
    }, [context]);
};

export default usePreventScrollFix;
