import React from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import CloseIcon from 'icons/16/Close';
import DownloadIcon from 'icons/16/Download';

import Button from './Button';
import {storyButtons, Td} from './__docs__/storyWithIcons';

export default {
    title: 'Example/Button',
    component: Button,
} as Meta;

export const Themes: TStorybookFunctionComponent = () => (
    <Box between="2">
        <Heading level="3">Secondary</Heading>
        <Box between="5" inline>
            <Button>Кнопушка</Button>
            <Button disabled>Кнопушка</Button>
        </Box>
        <Heading level="3">Primary</Heading>
        <Box between="5" inline>
            <Button theme="primary">Кнопушка</Button>
            <Button theme="primary" disabled>
                Кнопушка
            </Button>
        </Box>
        <Heading level="3">Outlined</Heading>
        <Box between="5" inline>
            <Button theme="outlined">Кнопушка</Button>
            <Button theme="outlined" disabled>
                Кнопушка
            </Button>
        </Box>
        <Heading level="3">Attention</Heading>
        <Box between="5" inline>
            <Button theme="attention">Кнопушка</Button>
            <Button theme="attention" disabled>
                Кнопушка
            </Button>
        </Box>
        <Heading level="3">Raised</Heading>
        <Box between="5" inline>
            <Button theme="raised">Кнопушка</Button>
            <Button theme="raised" disabled>
                Кнопушка
            </Button>
        </Box>
    </Box>
);

export const Shapes: TStorybookFunctionComponent = () => (
    <Box between="2">
        <Box>
            <Button size="l" shape="circle">
                +
            </Button>
        </Box>
        <Box>
            <Button size="l">-</Button>
        </Box>
    </Box>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                size: '28px',
                example: (
                    <React.Fragment>
                        <Button size="s">Кнопуля</Button>
                        <Button size="s" icon={<CloseIcon />}>
                            Кнопуля
                        </Button>
                        <Button size="s" icon={<CloseIcon />} />
                    </React.Fragment>
                ),
            },
            {
                name: 'm-inset',
                size: '36px',
                comment: 'по умолчанию',
                example: (
                    <React.Fragment>
                        <Button size="m-inset">Кнопуля</Button>
                        <Button size="m-inset" icon={<CloseIcon />}>
                            Кнопуля
                        </Button>
                        <Button size="m-inset" icon={<CloseIcon />} />
                    </React.Fragment>
                ),
            },
            {
                name: 'm',
                size: '36px',
                example: (
                    <React.Fragment>
                        <Button size="m">Кнопуля</Button>
                        <Button size="m" icon={<CloseIcon />}>
                            Кнопуля
                        </Button>
                        <Button size="m" icon={<CloseIcon />} />
                    </React.Fragment>
                ),
            },
            {
                name: 'l',
                size: '44px',
                example: (
                    <React.Fragment>
                        <Button size="l">Кнопуля</Button>
                        <Button size="l" icon={<CloseIcon />}>
                            Кнопуля
                        </Button>
                        <Button size="l" icon={<CloseIcon />} />
                    </React.Fragment>
                ),
            },
            {
                name: 'xl',
                size: '52px',
                example: (
                    <React.Fragment>
                        <Button size="xl">Кнопуля</Button>
                        <Button size="xl" icon={<CloseIcon />}>
                            Кнопуля
                        </Button>
                        <Button size="xl" icon={<CloseIcon />} />
                    </React.Fragment>
                ),
            },
        ]}
    />
);

export const Widths: TStorybookFunctionComponent = () => (
    <Box between="2">
        <Box>
            <Button>Auto</Button>
        </Box>
        <Box>
            <Button width="max">Max</Button>
        </Box>
        <Box>
            <Button width="max" iconRight={<DownloadIcon />}>
                Max with Icon
            </Button>
        </Box>
    </Box>
);

export const WithIcons: TStorybookFunctionComponent = () => (
    <table>
        <tbody>
            {storyButtons.map(({size, theme, text, icon}) => (
                <tr key={size}>
                    <Td>
                        <Text size="l" weight="bold">
                            {size}
                        </Text>
                    </Td>
                    <Td>
                        <Button icon={icon} size={size} theme={theme}>
                            {text}
                        </Button>
                    </Td>
                    <Td>
                        <Button iconRight={icon} size={size} theme={theme}>
                            {text}
                        </Button>
                    </Td>
                    <Td>
                        <Button
                            iconLeft={icon}
                            iconRight={icon}
                            size={size}
                            theme={theme}
                        >
                            {text}
                        </Button>
                    </Td>
                    <Td>
                        <Button iconLeft={icon} size={size} theme={theme} />
                    </Td>
                </tr>
            ))}
        </tbody>
    </table>
);
