import {FunctionComponent} from 'react';

import Box, {IBoxProps} from 'components/Box/Box';
import CloseIcon from 'icons/16/Close';
import CancelIcon from 'icons/16/Cancel';
import DeleteIcon from 'icons/16/Delete';
import DownloadIcon from 'icons/16/Download';

import {IButtonProps} from '../Button';

export const Td: FunctionComponent<IBoxProps> = props => (
    <td>
        <Box inset="2" between="4" inline {...props} />
    </td>
);

export const storyButtons: (IButtonProps & {text: string})[] = [
    {
        size: 's',
        theme: 'secondary',
        text: 'Отменить',
        icon: <CancelIcon />,
    },
    {
        size: 'm-inset',
        theme: 'primary',
        text: 'Скачать',
        icon: <DownloadIcon />,
    },
    {
        size: 'm',
        theme: 'outlined',
        text: 'Скачать',
        icon: <CloseIcon fill="currentColor" />,
    },
    {
        size: 'l',
        theme: 'attention',
        text: 'Удалить',
        icon: <DeleteIcon fill="currentColor" />,
    },
    {
        size: 'xl',
        theme: 'raised',
        text: 'Отменить',
        icon: <CancelIcon fill="currentColor" />,
    },
];
