import {FunctionComponent} from 'react';
import {compose, composeU} from '@bem-react/core';

import {
    Button as LegoDesktopButton,
    IButtonProps as ILegoButtonProps,
    withWidthMax,
    withViewDefault,
} from '@yandex-lego/components/Button/desktop';

/** _size */
import {withSizeS} from '../_size/Button_size_s';
import {withSizeMInset} from '../_size/Button_size_m-inset';
import {withSizeM} from '../_size/Button_size_m';
import {withSizeL} from '../_size/Button_size_l';
import {withSizeXL} from '../_size/Button_size_xl';
/** _theme */
import {withThemeSecondary} from '../_theme/Button_theme_secondary';
import {withThemePrimary} from '../_theme/Button_theme_primary';
import {withThemeOutlined} from '../_theme/Button_theme_outlined';
import {withThemeAttention} from '../_theme/Button_theme_attention';
import {withThemeRaised} from '../_theme/Button_theme_raised';
import {withThemePlain} from '../_theme/Button_theme_plain';
import {withThemePlus} from '../_theme/Button_theme_plus';
import {cnButton} from '../cnButton';
/** _state */
import {withButtonStateError} from '../_state/Button_state_error';
/** _form */
import {withButtonShapeCircle} from '../_shape/Button_shape_circle';

const YTLegoButtonWrapper: FunctionComponent<ILegoButtonProps> = props => (
    <LegoDesktopButton
        {...props}
        className={cnButton(null, [props.className])}
    />
);

export const ButtonPresenter = compose(
    composeU(withSizeS, withSizeMInset, withSizeM, withSizeL, withSizeXL),
    composeU(
        withThemeSecondary,
        withThemePrimary,
        withThemeOutlined,
        withThemeAttention,
        withThemeRaised,
        withThemePlain,
        withThemePlus,
    ),
    composeU(withButtonStateError),
    composeU(withButtonShapeCircle),
    withWidthMax,
    withViewDefault,
)(YTLegoButtonWrapper);
