/* eslint-disable react/display-name */
import React from 'react';
import {withBemMod} from '@bem-react/core';
import {Link, LinkProps} from 'react-router-dom';

import {ENTER_KEY_CODE} from 'constants/eventKeyCodes';

import {IButtonProps, cnButton} from '@yandex-lego/components/Button';

/**
 * FIXME: неправильные propTypes в Link. Нужно обновить react-router
 */
delete (Link as any).propTypes;

const LinkPresenter = React.forwardRef((props: LinkProps, ref: any) => {
    return <Link {...props} innerRef={ref} />;
});

LinkPresenter.displayName = 'LinkPresenter';

export interface IButtonRouterLinkProps {
    /**
     * Тип кнопки.
     */
    type?: 'router-link';

    /**
     * Адрес.
     */
    to?: string;

    tabIndex?: number;

    /**
     * TODO: Добавить описание.
     */
    target?: string;

    /**
     * TODO: Добавить описание.
     */
    rel?: string;

    /**
     * TODO: Добавить описание.
     */
    download?: string | boolean;
}

export const withRouterLink = withBemMod<IButtonRouterLinkProps, IButtonProps>(
    cnButton(),
    {type: 'router-link'},
    WrappedComponent => {
        return ({type, target, rel, to, disabled, tabIndex, ...props}) => {
            let relationship = rel;

            if (
                target === '_blank' &&
                rel !== undefined &&
                rel.indexOf('noopener') === -1
            ) {
                // Пользовательский атрибут имеет больший приоритет
                relationship = `${rel} noopener`;
            }

            return (
                <WrappedComponent
                    {...props}
                    rel={relationship}
                    target={target}
                    disabled={disabled}
                    pressKeys={[ENTER_KEY_CODE]}
                    to={disabled ? undefined : to}
                    tabIndex={disabled ? -1 : tabIndex}
                    // @ts-ignore (TODO: https://st.yandex-team.ru/ISL-5854)
                    type={null}
                    autoComplete={null}
                    as={LinkPresenter}
                />
            );
        };
    },
);
