import React, {PureComponent} from 'react';

import {ECalendarScrollSource} from 'components/Calendar/types';

import {ICalendarProps} from 'components/Calendar/Calendar';

export type TCalendarScrollContainerProps = Omit<
    ICalendarProps,
    'scrollPartPosition' | 'lastScrollSource'
>;

interface ICalendarScrollContainerState {
    scrollPartPosition: 0;
    source: Nullable<ECalendarScrollSource>;
    withAnimation: boolean;
}

export default function (CalendarComponent: React.FC<ICalendarProps>) {
    return class CalendarScrollContainer extends PureComponent<
        TCalendarScrollContainerProps,
        ICalendarScrollContainerState
    > {
        readonly state: ICalendarScrollContainerState = {
            scrollPartPosition: 0,
            source: null,
            withAnimation: false,
        };

        private handleScroll = ({
            scrollPartPosition,
            source,
        }: Pick<
            ICalendarScrollContainerState,
            'scrollPartPosition' | 'source'
        >): void => {
            const withAnimation = source === ECalendarScrollSource.MonthsList;
            const newScroll =
                scrollPartPosition ?? this.state.scrollPartPosition;

            this.setState({
                scrollPartPosition: newScroll,
                source,
                withAnimation,
            });
        };

        render(): React.ReactNode {
            const {scrollPartPosition, source, withAnimation} = this.state;

            return (
                <CalendarComponent
                    scrollPartPosition={scrollPartPosition}
                    lastScrollSource={source}
                    withAnimation={withAnimation}
                    onScroll={this.handleScroll}
                    {...this.props}
                />
            );
        }
    };
}
