import React, {useEffect, useState} from 'react';
import {Spring, animated} from 'react-spring';

import ScrollController from './components/ScrollController/ScrollController';

export interface ICalendarScrollControllerProps {
    scrollTop: number;
    scrollNode: Nullable<HTMLElement>;
    withoutAnimation: boolean;
    onSpringRest?: () => void;
}

const AnimatedScrollContainer = animated(ScrollController);

const CalendarScrollController: React.FC<ICalendarScrollControllerProps> =
    props => {
        const {
            scrollTop = 0,
            scrollNode = null,
            withoutAnimation = true,
            onSpringRest,
        } = props;

        const [from, setFrom] = useState(0);

        useEffect(() => {
            // Храним from, потому что при первом рендере Spring
            // анимция не происходит из-за того, что Spring не понимает
            // чему равен from

            if (!withoutAnimation || !scrollNode) {
                return;
            }

            setFrom(scrollNode.scrollTop);
        }, [withoutAnimation, scrollNode]);

        if (withoutAnimation) {
            return null;
        }

        return (
            <Spring
                from={{scrollTop: from}}
                to={{scrollTop}}
                onRest={onSpringRest}
            >
                {({scrollTop: scrollTopValue}): React.ReactElement => {
                    return (
                        <AnimatedScrollContainer
                            scrollNode={scrollNode}
                            scrollTopValue={scrollTopValue}
                        />
                    );
                }}
            </Spring>
        );
    };

export default React.memo(CalendarScrollController);
