import {useEffect} from 'react';

export interface IScrollControllerProps {
    // Не scrollTop, потому что react-spring почему-то не передает scrollTop/scrollLeft внутрь animated компонента
    // https://github.com/pmndrs/react-spring/blob/4bd575aada8dbb0ae073433c83d687d6e517d369/targets/web/src/index.ts#L19
    scrollTopValue: number;
    scrollNode: Nullable<HTMLElement>;
}

const ScrollController = ({
    scrollNode,
    scrollTopValue,
}: IScrollControllerProps) => {
    useEffect(() => {
        if (scrollNode) {
            scrollNode.scrollTop = scrollTopValue;
        }
    });

    return null;
};

export default ScrollController;
