import React, {PureComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {TWeekDayObject} from 'components/Calendar/types';

import cx from './CalendarWeekdays.scss';

interface ICalendarWeekdaysProps extends IWithClassName {
    weekdays: TWeekDayObject[];
}

class CalendarWeekdays extends PureComponent<ICalendarWeekdaysProps> {
    static readonly defaultProps: ICalendarWeekdaysProps = {
        className: '',
        weekdays: [],
    };

    private renderWeekday = ({
        weekdayLabel,
        isWeekend,
    }: TWeekDayObject): React.ReactNode => {
        return (
            <div
                key={weekdayLabel}
                className={cx('weekday', {
                    weekday_weekend_yes: isWeekend,
                })}
            >
                {weekdayLabel}
            </div>
        );
    };

    render(): React.ReactNode {
        const {weekdays, className} = this.props;

        return (
            <div className={cx('calendarWeekdays', className)}>
                {weekdays.map(this.renderWeekday)}
            </div>
        );
    }
}

export default CalendarWeekdays;
