import moment, {Moment} from 'moment';

/**
 * Вычесляет moment к которому подскролить календарь
 */
export default function getScrolledMoment(
    startDate: Date | undefined,
    endDate: Date | undefined,
    minDate: Date,
): Moment | undefined {
    const scrolledDate = startDate || endDate || minDate;
    const scrolledMoment = moment(scrolledDate);
    const minMoment = moment(minDate);

    const scrolledMomentStartOfMonth = minMoment.clone().startOf('month');
    const weekIndexOfFirstMonth = scrolledMoment.diff(
        scrolledMomentStartOfMonth,
        'weeks',
    );

    if (weekIndexOfFirstMonth >= 3) {
        const previousWeekForScrolledMoment = scrolledMoment
            .clone()
            .add(-1, 'week');

        if (previousWeekForScrolledMoment.isSame(scrolledMoment, 'month')) {
            return previousWeekForScrolledMoment;
        }

        return getEndDateOfMonth(previousWeekForScrolledMoment);
    }
}

/**
 * Получает последний день момента, но часы/минуты/... оставляет как в исходном Moment
 */
function getEndDateOfMonth(m: Moment): Moment {
    return m
        .clone()
        .endOf('month')
        .hours(m.hours())
        .minutes(m.minutes())
        .seconds(m.seconds())
        .milliseconds(m.milliseconds());
}
