import {ECardWithDeviceLayoutVariation} from 'components/CardWithDeviceLayout/types/ECardWithDeviceLayoutVariation';
import {ICardWithDeviceLayoutOptionalPaddings} from 'components/CardWithDeviceLayout/types/ICardWithDeviceLayoutOptionalPaddings';

import {TBoxSizes} from 'components/Box/Box';

/**
 * Все карточки должны иметь визуально следующие отступы
 * | DESKTOP | MOBILE
 * |  5      |  4
 * | 8 8     | 3 3
 * |  7      |  5
 */

interface IPaddingPlatformSizes {
    top: TBoxSizes;
    right: TBoxSizes;
    bottom: TBoxSizes;
    left: TBoxSizes;
}

interface IPaddingSizes {
    DESKTOP: IPaddingPlatformSizes;
    MOBILE: IPaddingPlatformSizes;
}

const STANDARD_MAIN_SIZES: IPaddingSizes = {
    DESKTOP: {
        top: 7,
        right: 8,
        bottom: 8,
        left: 8,
    },
    MOBILE: {
        top: 4,
        right: 4,
        bottom: 5,
        left: 4,
    },
} as const;

const STANDARD_ASIDE_SIZES: IPaddingSizes = {
    ...STANDARD_MAIN_SIZES,
    DESKTOP: {
        top: 7,
        right: 6,
        bottom: 7,
        left: 6,
    },
} as const;

export default function getPaddingSizes(
    variation: ECardWithDeviceLayoutVariation,
    paddings: ICardWithDeviceLayoutOptionalPaddings,
): IPaddingSizes {
    const sizes =
        variation === ECardWithDeviceLayoutVariation.MAIN
            ? STANDARD_MAIN_SIZES
            : STANDARD_ASIDE_SIZES;

    const {paddingTop, paddingBottom} = paddings;

    return {
        DESKTOP: {
            ...sizes.DESKTOP,
            top: paddingTop ?? sizes.DESKTOP.top,
            bottom: paddingBottom ?? sizes.DESKTOP.bottom,
        },
        MOBILE: {
            ...sizes.MOBILE,
            top: paddingTop ?? sizes.MOBILE.top,
            bottom: paddingBottom ?? sizes.MOBILE.bottom,
        },
    };
}
