import {FunctionComponent} from 'react';

import ArrowLeftIcon from 'icons/16/ArrowLeft';
import ArrowRightIcon from 'icons/16/ArrowRight';
import RoundButton, {
    IRoundButtonProps,
} from 'components/RoundButton/RoundButton';

import cx from './CarouselButton.scss';

export type ArrowsType = 'light' | 'dark';
export type ArrowsPositionType = 'center' | 'bottom';

type RoundButtonTheme = {
    size: IRoundButtonProps['size'];
    theme: IRoundButtonProps['theme'];
};

const lightTheme: RoundButtonTheme = {
    size: 'm',
    theme: 'white',
};

const darkTheme: RoundButtonTheme = {
    size: 's',
    theme: 'dark',
};

export interface ICarouselButtonProps {
    type: 'next' | 'prev';
    arrowsType?: ArrowsType;
    arrowsPosition?: ArrowsPositionType;
    disabled?: boolean;
    onClick: () => void;
}

const CarouselButton: FunctionComponent<ICarouselButtonProps> = ({
    type,
    arrowsType,
    arrowsPosition,
    disabled,
    onClick,
}) => {
    const buttonTheme = arrowsType === 'light' ? lightTheme : darkTheme;

    return (
        <div
            className={cx(
                'root',
                `root_direction_${type}`,
                `root_type_${arrowsType}`,
                `root_position_${arrowsPosition}`,
            )}
        >
            <RoundButton
                icon={type === 'next' ? <ArrowRightIcon /> : <ArrowLeftIcon />}
                onClick={onClick}
                disabled={disabled}
                {...buttonTheme}
            />
        </div>
    );
};

CarouselButton.defaultProps = {
    arrowsPosition: 'center',
    arrowsType: 'light',
};

export default CarouselButton;
