import React, {memo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import cx from './CategoriesList.scss';

export interface ICategory {
    key: string;
    value: string | React.ReactElement;
}

export interface ICategoriesListProps extends IWithClassName {
    categories?: ICategory[];
    currentCategoryKey?: string;
    onCategoryChange?: (category: ICategory) => void;
}

const CategoriesList: React.FC<ICategoriesListProps> = ({
    className,
    categories,
    currentCategoryKey,
    onCategoryChange,
}) => {
    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            {categories?.map(category => {
                const {key, value} = category;
                const onClick = (): void => {
                    onCategoryChange?.(category);
                };
                const selected =
                    currentCategoryKey === key && deviceType.isDesktop;

                return (
                    <div
                        key={key}
                        className={cx('category', {
                            category_selected: selected,
                        })}
                        onClick={selected ? undefined : onClick}
                    >
                        {value}
                    </div>
                );
            })}
        </div>
    );
};

export default memo(CategoriesList);
