import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useToggle} from 'utilities/hooks/useToggle';

import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import CheckButton from './CheckButton';

export default {
    title: 'Example/CheckButton',
    component: CheckButton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isChecked, toggle] = useToggle(false);

    return (
        <CheckButton checked={isChecked} onClick={toggle}>
            Touch me
        </CheckButton>
    );
};

export const States: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'Checked',
                props: {checked: true},
                example: (
                    <CheckButton checked={true} onClick={noop}>
                        Touch me
                    </CheckButton>
                ),
            },
            {
                name: 'Unchecked',
                props: {checked: false},
                example: (
                    <CheckButton checked={false} onClick={noop}>
                        Touch me
                    </CheckButton>
                ),
            },
            {
                name: 'Disabled checked',
                props: {disabled: true, checked: true},
                example: (
                    <CheckButton checked={true} disabled={true} onClick={noop}>
                        Touch me
                    </CheckButton>
                ),
            },
            {
                name: 'Disabled unchecked',
                props: {disabled: true, checked: false},
                example: (
                    <CheckButton checked={false} disabled={true} onClick={noop}>
                        Touch me
                    </CheckButton>
                ),
            },
        ]}
    />
);
