import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useToggle} from 'utilities/hooks/useToggle';

import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import Checkbox from './Checkbox';

export default {
    title: 'Example/Checkbox',
    component: Checkbox,
} as Meta;

export const State: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'Default',
                props: {checked: false},
                example: <Checkbox checked={false} label="Страна грез" />,
            },
            {
                name: 'Checked',
                props: {checked: true},
                example: <Checkbox checked label="Страна грез" />,
            },
            {
                name: 'Disabled default',
                props: {checked: false, disabled: true},
                example: (
                    <Checkbox checked={false} disabled label="Страна грез" />
                ),
            },
            {
                name: 'Checked default',
                props: {checked: true, disabled: true},
                example: <Checkbox checked disabled label="Страна грез" />,
            },
        ]}
    />
);

export const Sizes: TStorybookFunctionComponent = () => {
    const [isCheckedS, toggleS] = useToggle(false);
    const [isCheckedM, toggleM] = useToggle(false);

    return (
        <StyleguidistSizeTable
            sizes={[
                {
                    name: 's',
                    size: '16px',
                    example: (
                        <Checkbox
                            checked={isCheckedS}
                            onChange={toggleS}
                            size="s"
                            label="Волшебный мир"
                        />
                    ),
                },
                {
                    name: 'm',
                    size: '20px',
                    example: (
                        <Checkbox
                            checked={isCheckedM}
                            onChange={toggleM}
                            size="m"
                            label="Волшебный мир"
                        />
                    ),
                    comment: 'По умолчанию',
                },
            ]}
        />
    );
};

export const Multiline: TStorybookFunctionComponent = () => {
    const [isChecked, toggle] = useToggle(false);

    return (
        <StyleguidistPropTable
            props={[
                {
                    name: 'Default M',
                    props: {size: 'm'},
                    example: (
                        <div style={{width: '200px'}}>
                            <Checkbox
                                checked={isChecked}
                                onChange={toggle}
                                size="m"
                                label="Съешь ещё этих мягких французских булок, да выпей же чаю."
                            />
                        </div>
                    ),
                },
                {
                    name: 'Default S',
                    props: {size: 's'},
                    example: (
                        <div style={{width: '200px'}}>
                            <Checkbox
                                checked={isChecked}
                                onChange={toggle}
                                size="s"
                                label="Съешь ещё этих мягких французских булок, да выпей же чаю."
                            />
                        </div>
                    ),
                },
                {
                    name: 'Single line M',
                    props: {size: 'm', lines: 'one'},
                    example: (
                        <div style={{width: '200px'}}>
                            <Checkbox
                                checked={isChecked}
                                onChange={toggle}
                                size="m"
                                lines="one"
                                label="Съешь ещё этих мягких французских булок, да выпей же чаю."
                            />
                        </div>
                    ),
                },
                {
                    name: 'Single line s',
                    props: {size: 's', lines: 'one'},
                    example: (
                        <div style={{width: '200px'}}>
                            <Checkbox
                                checked={isChecked}
                                onChange={toggle}
                                size="s"
                                lines="one"
                                label="Съешь ещё этих мягких французских булок, да выпей же чаю."
                            />
                        </div>
                    ),
                },
            ]}
        />
    );
};
