import React, {
    ChangeEventHandler,
    FocusEventHandler,
    MouseEventHandler,
    RefObject,
    FunctionComponent,
} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useUniqId} from 'hooks/useUniqId';

import {CheckboxPresenter} from 'components/Checkbox/controls/CheckboxPresenter';

export type TCheckboxSize = 's' | 'm';

export interface ICheckboxProps extends IWithClassName {
    /** Ссылка на корневой DOM-элемент компонента */
    innerRef?: RefObject<HTMLElement>;

    /** Ссылка на дом-ноду нативного контрола */
    controlRef?: RefObject<HTMLInputElement>;

    id?: string;

    name?: string;

    value?: string | number | string[] | undefined;

    /** Текст подписи к чекбоксу */
    label?: React.ReactNode;

    /** Состояние переключателя: включен или выключен */
    checked?: boolean;

    disabled?: boolean;

    size?: TCheckboxSize;

    lines?: 'one';

    onChange?: ChangeEventHandler<HTMLInputElement>;

    onBlur?: FocusEventHandler<HTMLInputElement>;

    onFocus?: FocusEventHandler<HTMLInputElement>;

    onMouseUp?: MouseEventHandler<HTMLInputElement>;

    onMouseDown?: MouseEventHandler<HTMLInputElement>;

    onMouseEnter?: MouseEventHandler<HTMLInputElement>;

    onMouseLeave?: MouseEventHandler<HTMLInputElement>;
}

const Checkbox: FunctionComponent<ICheckboxProps> = (props: ICheckboxProps) => {
    const {id: rawId, ...restProps} = props;
    const uniqId = useUniqId('travel-control-');
    const id = typeof rawId === 'undefined' ? uniqId : rawId;

    const otherProps = {
        /* фикс ворнинга в консоли
         * Warning: You provided a checked prop to a form field without an onChange handler.
         * This will render a read-only field. If the field should be mutable use defaultChecked.
         * Otherwise, set either onChange or readOnly.
         */
        readOnly: !restProps.onChange,
        ...restProps,
    };

    return (
        <CheckboxPresenter
            {...otherProps}
            id={id}
            view="outline"
            theme="primary"
        />
    );
};

Checkbox.defaultProps = {
    size: 'm',
};

export default Checkbox;
