import React from 'react';
import {LoadableComponent} from '@loadable/component';

import {ILoadDynamicResourceOptions} from 'utilities/hooks/useNeedToLoadDynamicResource';
import usePreloadChunks from 'utilities/hooks/usePreloadChunks';

interface IChunksPreloaderProps extends ILoadDynamicResourceOptions {
    preloadChunks: LoadableComponent<any>[];
}

const ChunksPreloader: React.FC<IChunksPreloaderProps> = props => {
    const {preloadChunks, ...loadResourceOptions} = props;

    usePreloadChunks(preloadChunks, loadResourceOptions);

    return null;
};

export default ChunksPreloader;
