import {Component, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import Spinner from 'components/Spinner/Spinner';

import cx from './ComponentLoading.scss';

// todo use spinnerSize type from Spinner after update
export interface IComponentLoadingProps extends IWithClassName {
    spinnerSize?: 'xxs' | 'xs' | 's' | 'm' | 'l' | 'xl' | 'xxl';
}

export default class PageLoading extends Component<IComponentLoadingProps> {
    render(): ReactNode {
        const {className, spinnerSize} = this.props;

        return (
            <div className={cx(className, 'root')}>
                <Spinner size={spinnerSize} />
            </div>
        );
    }
}
