import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {EOrganicGoals} from 'utilities/metrika/types/goals/organic';
import {IBlockWithTitle} from 'types/common/seoPages/IBlockWithTitle';
import {TTransportProjectName} from 'types/common/TTransportProjectName';
import IGetCrossSaleHotelsResponseV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV1';

import {reachGoal} from 'utilities/metrika';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {getRegionUrl} from 'projects/depreacted/hotels/utilities/urls/getRegionUrl';

import Box from 'components/Box/Box';
import Price from 'components/Price/Price';
import Heading from 'components/Heading/Heading';
import CrossSaleMap from 'components/CrossSaleMap/CrossSaleMap';

interface ICrossSaleHotelsBlockProps
    extends IWithClassName,
        IBlockWithTitle,
        IGetCrossSaleHotelsResponseV1 {
    vertical: TTransportProjectName;
}

const CrossSaleHotelsBlock = React.forwardRef<
    HTMLDivElement,
    ICrossSaleHotelsBlockProps
>(function LinkList(props, ref) {
    const {className, title, vertical, ...mapProps} = props;
    const {minPriceInRegion, region} = mapProps;
    const deviceType = useDeviceType();

    const handleClick = useCallback(() => {
        reachGoal(EOrganicGoals.CROSS_SALES_SEO, {
            organic: {
                crossSale: {
                    hotels: vertical,
                },
            },
        });
    }, [vertical]);

    return (
        <Box className={className} ref={ref}>
            <Box below={deviceType.isDesktop ? 5 : 4}>
                <Heading level={2}>{title}</Heading>
            </Box>

            <CrossSaleMap
                crossSaleData={mapProps}
                linkUrl={getRegionUrl({regionSlug: region.slug || ''})}
                showMapOnIntersection
                onLinkClick={handleClick}
                additionalTitle={
                    minPriceInRegion ? (
                        <Price {...minPriceInRegion} isFrom />
                    ) : null
                }
            />
        </Box>
    );
});

export default CrossSaleHotelsBlock;
