import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import {getRegionUrl} from 'projects/depreacted/hotels/utilities/urls/getRegionUrl';

import {HOTELS_CROSS_SALE_DATA} from 'components/CrossSaleMap/__mocks__/crossSaleData';

import CrossSaleMap from './CrossSaleMap';

export default {
    title: 'Example/CrossSaleMap',
    component: CrossSaleMap,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <CrossSaleMap
        crossSaleData={HOTELS_CROSS_SALE_DATA}
        linkUrl={getRegionUrl({regionSlug: 'sochi'})}
    />
);
