import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {DateLikeType} from 'utilities/dateUtils';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

export interface IDateLabelProps extends IWithClassName, IWithQaAttributes {
    startDate: DateLikeType;
    endDate: DateLikeType;
    /**
     * Сокращенное отображение
     */
    shortFormat?: boolean;
    /**
     * Если startDate и endDate - одна дата, то схлапывать
     */
    checkSameDate?: boolean;
}

const DateLabel: React.FC<IDateLabelProps> = props => {
    const {
        startDate,
        endDate,
        className,
        shortFormat = true,
        checkSameDate = true,
    } = props;

    return (
        <span className={className} {...prepareQaAttributes(props)}>
            {humanizePeriod(startDate, endDate, {
                short: shortFormat,
                checkSameDate,
            })}
        </span>
    );
};

export default DateLabel;
