import {FunctionComponent} from 'react';

import DateLabel from 'components/DateLabel/DateLabel';

interface ITemplateProps {
    startDate: Date;
    endDate: Date;
    isDifferentYears?: boolean;
}

const Template: FunctionComponent<ITemplateProps> = ({
    startDate,
    endDate,
    isDifferentYears,
}) => {
    const firstDate = new Date(startDate);
    const secondDate = new Date(endDate);

    if (isDifferentYears) {
        firstDate.setFullYear(firstDate.getFullYear() + 1);
        secondDate.setFullYear(secondDate.getFullYear() + 1);
    }

    return (
        <>
            Короткий формат:{' '}
            <DateLabel startDate={firstDate} endDate={secondDate} /> <br />
            Длинный формат:{' '}
            <DateLabel
                startDate={firstDate}
                endDate={secondDate}
                shortFormat={false}
            />
        </>
    );
};

export default Template;
