import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import DatePicker from './DatePicker';

export default {
    title: 'Example/DatePicker',
    component: DatePicker,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
                .trigger {
                    border: 2px solid gray;
                }
            `}
        </style>
        <DeviceTypeContext.Consumer>
            {(deviceType): ReactNode => (
                <DatePicker
                    triggerClassName="trigger"
                    minDate={new Date(2018, 0, 1)}
                    maxDate={new Date(2019, 0, 1)}
                    nowDate={new Date(2018, 0, 15)}
                    startDate={null}
                    endDate={null}
                    size="xl"
                    startDatePlaceholder=""
                    canRenderResetIcon
                    cutPastWeeks
                    isShortTriggerFormatDate
                    triggerViewType="union"
                    triggerValue=""
                    isModalView={false}
                    deviceType={deviceType}
                    canAutoHideCalendar={false}
                    onDaySelect={noop}
                />
            )}
        </DeviceTypeContext.Consumer>
    </>
);
