import moment from 'moment';

import {HUMAN_SHORT, HUMAN_SHORT_WITH_YEAR} from 'utilities/dateUtils/formats';
import {formatDate, formatDateRange} from 'utilities/dateUtils';

export default function getFormattedTextValue(
    left: Date,
    right?: Nullable<Date>,
): [string, string] {
    if (!right) {
        const isCurrentYear = moment(left).isSame(moment(), 'year');
        const yearIsShown = !isCurrentYear;
        const formatted = formatDate(
            left,
            yearIsShown ? HUMAN_SHORT_WITH_YEAR : HUMAN_SHORT,
        );

        return [formatted, ''];
    }

    const delimiter = ' — ';

    const [leftFormatted, rightFormatted] = formatDateRange(left, right, {
        delimiter,
        forceHideFromDateYearInRange: true,
    }).split(delimiter);

    return [leftFormatted, rightFormatted];
}
