import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/avia-emptySerp';

import Container from 'components/Layouts/Container/Container';
import EmptySerp from 'components/EmptySerp/EmptySerp';

import cx from './EmptySerpWithContainer.scss';

interface IEmptySerpWithContainerProps extends IWithQaAttributes {
    title?: React.ReactNode;
    text?: React.ReactNode;
}

const EmptySerpWithContainer: React.FC<IEmptySerpWithContainerProps> = ({
    title = i18nBlock.title(),
    text = i18nBlock.text(),
    ...props
}) => {
    const deviceType = useDeviceType();

    return (
        <Container
            className={cx(
                'emptySerpWrapper',
                deviceMods('emptySerpWrapper', deviceType),
                'fullHeight',
            )}
        >
            <EmptySerp
                title={title}
                text={text}
                withIcon
                fullHeight
                {...prepareQaAttributes(props)}
            />
        </Container>
    );
};

export default EmptySerpWithContainer;
